<?php
include("config.php");
date_default_timezone_set("Asia/Kolkata");

$dt=date("Y");
$m=date("m");

if($m<4)
{
    $fy=($dt-1)." - ".$dt;
}
else
{
    $fy=$dt." - ".($dt+1);
}

$type=$_GET['type'];
$aid=$_GET['id'];

if($type=="Agency")
{
    $sql=mysqli_query($db,"select * from agency where id='$aid' ");
}
else if($type=="Farmer")
{
    $sql=mysqli_query($db,"select * from farmers where id='$aid' ");
}
else if($type=="Supplier")
{
    $sql=mysqli_query($db,"select * from suppliers where id='$aid' ");
}
else if($type=="Dealer")
{
    $sql=mysqli_query($db,"select * from dealers where id='$aid' ");
}
else if($type=="Transport")
{
    $sql=mysqli_query($db,"select * from transport where id='$aid' ");
}
else
{
    $sql=mysqli_query($db,"select * from employees where id='$aid' ");
}


$row=mysqli_fetch_assoc($sql);
?>
<html>
    <head>
        <title>Ledger Print</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@100..900&display=swap" rel="stylesheet">

<style>
        body
        {
            font-family: "Noto Sans JP", sans-serif;
            
        }
        
        @page
        {
            size:A4;
            margin:1.5cm;
            text-align:center;
        }
        
        @media print {
    body {
        margin: 0;
        text-align:center;
    }
}
        </style>
    </head>
    <body>
        <div class="container">
            <div class="row">
                <div class="col-md-12 d-flex flex-column justify-content-center align-items-center mt-4">
                    <p>FY ( <?php echo $fy;?> )</p>
                    <h1>Dyne Foundation</h1>
                    <h5>Ledger of <?php echo $row['name'];?></h5>
                    <label></label>
                    <label>Address: <?php echo $row['address'];?></label>
                    <label>Phone: <?php echo $row['phone'];?></label>
                    <?php
                    if($type!="Employee")
                    {
                        echo "<label>GST: ".$row['gst']."</label>";
                    }
                    ?>
                    
                </div>
                <div class="col-md-12 d-flex justify-content-center align-items-center mt-4">
                    <table class="table table-striped" style="width:100%;">
  <thead>
    <tr>
      <th scope="col" style="width:8%;">Date</th>
      <th scope="col" style="width:8%;">Voucher</th>
      <th scope="col" style="width:31%;">Particulars</th>
      <th scope="col" style="width:15%;">Debit</th>
      <th scope="col" style="width:15%;">Credit</th>
      <th scope="col" style="width:15%;">Balance</th
      <th scope="col" style="width:3%;"></th>
    </tr>
  </thead>
  <tbody>
      <?php
      if($type=="Agency")
      {
          $sql=mysqli_query($db,"select * from agledger where aid='$aid' order by date asc,id asc");
      }
      else if($type=="Farmers")
      {
          $sql=mysqli_query($db,"select * from fledger where fid='$aid' order by date asc,id asc");
      }
      else if($type=="Supplier")
      {
          $sql=mysqli_query($db,"select * from supledger where sid='$aid' order by date asc,id asc");
      }
      else if($type=="Dealer")
      {
          $sql=mysqli_query($db,"select * from dealedger where did='$aid' order by date asc,id asc");
      }
      else if($type=="Transport")
      {
          $sql=mysqli_query($db,"select * from transledger where tid='$aid' order by date asc,id asc");
      }
      else
      {
          $sql=mysqli_query($db,"select * from empledger where emid='$aid' order by date asc,id asc");
      }
                      
                      $sl=0;
                      $bal=0;
                      $dsum=0;
                      $csum=0;
                      if(mysqli_num_rows($sql))
                      {
                          while($row=mysqli_fetch_assoc($sql))
                          {
                              
                              
                              $bal=$bal+($row['debit']-$row['credit']);
                              $dsum=$dsum+$row['debit'];
                              $csum=$csum+$row['credit'];
                              
                              ?>
                              <tr>
                                  
                    <td style="width:8%;"><?php echo $row['date'];?></td>
                    <td style="width:8%;"><?php echo $row['voucher'];?></td>
                    <td style="width:31%;">
                        
                        <?php
                        if(!empty($row['reference']))
                        {
                            ?>
                            <strong><?php echo $row['reference'];?></strong><br>
                            <?php
                        }
                        ?>
                        
                        <?php
                        if(!empty($row['mode']))
                        {
                            ?>
                            <strong><?php echo $row['mode'];?></strong><br>
                            <?php
                        }
                        ?>
                        
                        <textarea style="background-color:transparent;resize:none;border:none;padding:0;"><?php echo $row['remarks'];?></textarea>
                    
                    </td>
                    
                    
                    <td style="width:15%;"><?php echo sprintf("%.2f",$row['debit']);?></td>
                    <td style="width:15%;"><?php echo sprintf("%.2f",$row['credit']);?></td>
                    <td style="width:15%;"><?php echo abs(sprintf("%.2f",$bal));?></td>
                    <td style="width:3%;">
                        <?php
                        if($bal>0)
                        {
                            echo "Dr";
                        }
                        else
                        {
                            echo "Cr";
                        }
                        ?>
                    </td>
                  </tr>
                              <?php
                          }
                      }
                      ?>
                      <tr>
                          <td colspan="3"><strong style="display:flex;justify-content:end;">Total</strong></td>
                          <td><?php echo sprintf("%.2f",$dsum);?></td>
                          <td><?php echo sprintf("%.2f",$csum);?></td>
                          <td><?php echo abs(sprintf("%.2f",$bal));?></td>
                          <td>
                              <?php
                        if($bal>0)
                        {
                            echo "Dr";
                        }
                        else
                        {
                            echo "Cr";
                        }
                        ?>
                          </td>
                      </tr>
    
  </tbody>
</table>
                </div>
                
            </div>
        </div>
        <script src="plugins/jquery/jquery.min.js"></script>
        <script>
 $(function(){
    window.print();
    $("body").hover(function(){
        window.close();
    });
});
</script>
    </body>
</html>