<?php
include("config.php");
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Manage Manufacture - Dyne Foundation</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- DataTables -->
  <link rel="stylesheet" href="plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">
  <!-- Navbar -->
  <?php include("header.php");?>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <?php include("sidebar.php");?>
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>View Manufacture</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="dashboard.php">Home</a></li>
              <li class="breadcrumb-item active">View Manufacture</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            

            <div class="card">
              <div class="card-header col-12 row d-flex justify-content-between align-items-center">
                  <div class="col-6">
                      <h3 class="card-title">View All Manufacture Data</h3>
                  </div>
                <div class="col-6 d-flex justify-content-end">
                    <a class="btn btn-primary" href="newManufactureData.php">+ Add New</a>
                </div>
                
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                      <th>Sl No</th>
                      <th>Date</th>
                    <th>MNFT No</th>
                    
                    <th>Lot No</th>
                    <th>Crop Variety</th>
                    <th>Qty after Grading</th>
                    <th>LG</th>
                    <th>Under Size</th>
                    <th>Other Loss</th>
                    
                    
                    
                    <th>Total Qty</th>
                    <th>Total Grading Qty</th>
                    <th>Total LG</th>
                    <th>Total Under Size</th>
                    <th>Total O.Loss</th>
                    <th>Total Loss</th>
                    
                    
                    
                  </tr>
                  </thead>
                  <tbody>
                      <?php
                      $sql=mysqli_query($db,"select manufacture.*,manufacture_desc.*,quality.lotno from manufacture,manufacture_desc,quality where manufacture_desc.mnftid=manufacture.mnftid and quality.id=manufacture_desc.lotid order by manufacture.date asc,manufacture_desc.mnftid asc");
                      $sl=0;
                      $nr=0;
                      if(mysqli_num_rows($sql))
                      {
                          while($row=mysqli_fetch_assoc($sql))
                          {
                             
                              
                              /*$lot=$row['lotno'];
                              
                              $grsql=mysqli_query($db,"select grno from pur_desc where lotno='$lot' ");
                              list($grno)=mysqli_fetch_row($grsql);*/
                              
                              $lot=$row['lotno'];
                              
                              $cvsql=mysqli_query($db,"select cropid,cropvar from pur_desc where id='$lot' ");
                              list($crop,$cvar)=mysqli_fetch_row($cvsql);
                              
                              $crsql=mysqli_query($db,"select cropname from crops where id='$crop'");
                              list($cropname)=mysqli_fetch_row($crsql);
                              
                              $crvsql=mysqli_query($db,"select variety from cvariety where id='$cvar'");
                              list($crvname)=mysqli_fetch_row($crvsql);
                              
                              $lotsql=mysqli_query($db,"select * from manufacture_desc where mnftid='".$row['mnftid']."'");
                              $lotnum=mysqli_num_rows($lotsql);
                              
                             $sl=$sl+1;
                              
                              
                              
                              $nr=$nr+1;
                              
                              
                              
                              
                              
                              
                              
                              
                              
                              ?>
                <tr ondblclick="window.location.href='editManufactureData.php?mid=<?php echo $row['mnftid'];?>'">
                       <td><?php echo $sl;?></td>
                    <td><?php echo $row['date'];?></td>
                    <td>MNFT-<?php echo $row['mnftid'];?></td>
                    <td><?php echo $row['mlot'];?></td>
                    <td><?php echo $cropname." - ".$crvname;?></td>
                    <td><?php echo $row['gqty'];?></td>
                    <td><?php echo $row['lg'];?></td>
                    <td><?php echo $row['under'];?></td>
                    <td><?php echo $row['otherl'];?></td>
                    <td>
                        <?php
                        if($nr==1)
                        {
                            echo $row['tqty'];
                        }
                        ?>
                    
                    </td>
                    <td>
                        <?php
                        if($nr==1)
                        {
                            echo $row['tgqty'];
                        }
                        ?>
                        
                    
                    </td>
                    <td>
                        <?php
                        if($nr==1)
                        {
                            echo $row['tlgqty'];
                        }
                        ?>
                        
                    
                    </td>
                    <td>
                        <?php
                        if($nr==1)
                        {
                            echo $row['tunqty'];
                        }
                        ?>
                        
                    
                    
                    </td>
                    <td>
                        <?php
                        if($nr==1)
                        {
                            echo $row['tolqty'];
                        }
                        ?>
                        
                    
                    </td>
                    <td>
                        
                        <?php
                        if($nr==1)
                        {
                            echo $row['totloss'];
                        }
                        ?>
                        
                    
                    </td>
                </tr>
                              
                                  
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                   
                                  <?php
                              if($nr==$lotnum)
                              {
                                  $nr=0;
                              }
                          }
                      }
                      ?>
                  
                 
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <?php include("footer.php");?>
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- DataTables  & Plugins -->
<script src="plugins/datatables/jquery.dataTables.min.js"></script>
<script src="plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="plugins/jszip/jszip.min.js"></script>
<script src="plugins/pdfmake/pdfmake.min.js"></script>
<script src="plugins/pdfmake/vfs_fonts.js"></script>
<script src="plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>

<!-- Page specific script -->
<script>
  $(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": false, "autoWidth": false,
      "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
    });
  });
</script>
</body>
</html>
