<?php
include("config.php");
date_default_timezone_set("Asia/Kolkata");

$grsql=mysqli_query($db,"select grval from grno where id='1' ");
list($grval)=mysqli_fetch_row($grsql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Generate New Purchase - Cursor Tech</title>

  <!-- Google Font: Source Sans Pro -->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
  
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<!-- Site wrapper -->
<div class="wrapper">
  <!-- Navbar -->
  
    <!-- Left navbar links -->
    <?php include("header.php");?>
  
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <?php include("sidebar.php");?>
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Add Production</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Add Production</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">
          <form action="" method="POST" class="col-12 row">
              <?php
              if(isset($_GET['data']))
              {
                  ?>
                <div class="col-md-12">
                  <div class="card card-success">
                    <div class="card-header">
                        <h3 class="card-title text-white">New Purchase Data Added...</h3>
                    </div>
                    </div>
                </div>
                  <?php
              }
              ?>
              
              
        <div class="col-md-6">
          <div class="card card-primary">
            <div class="card-header">
              <h3 class="card-title">Basic Details</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <input type="hidden" name="adid" value="<?php echo $_COOKIE['admin'];?>">
            <div class="card-body">
                <div class="form-group">
                <label for="inputName">Date</label>
                <input type="date" id="inputName" class="form-control" name="date" value="<?echo date('Y-m-d');?>" required>
              </div>
              <div class="form-group">
                <label for="inputName">GR No</label>
                <input type="number" id="inputName" class="form-control" name="grno" value="<?php echo $grval+1;?>" required>
              </div>
              <div class="form-group">
                <label for="inputName">Challan No</label>
                <input type="text" id="inputName" class="form-control" name="challan" value="" required>
              </div>
              <div class="form-group">
                <label for="inputName">Entry For</label>
                <select id="enfor" class="form-control" name="entryfor">
                    <option selected disabled>Select Your Choice</option>
                    <option>Agents</option>
                    <option>Farmers</option>
                </select>
                
              </div>
              <div class="form-group" id="end-box">
                <label for="inputDescription" id="enlabel"></label>
                <select class="form-control" id="endata" name="afid">
                    
                </select>
              </div>
            <!--  <div class="form-group">
                <label for="inputStatus">Status</label>
                <select id="inputStatus" class="form-control custom-select">
                  <option selected disabled>Select one</option>
                  <option>On Hold</option>
                  <option>Canceled</option>
                  <option>Success</option>
                </select>
              </div> -->
              
            
            </div>
            <!-- /.card-body -->
          </div>
          
          <div class="card card-info">
            <div class="card-header">
              <h3 class="card-title">Crop Details</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group">
                <label for="inputClientCompany">Crop Type</label>
                <select class="form-control" name="cropid" id="cropid">
                    <option selected disabled>Select Crop Type</option>
                    <?php
                    $csql=mysqli_query($db,"select * from crops");
                    if(mysqli_num_rows($csql))
                    {
                        while($crow=mysqli_fetch_assoc($csql))
                        {
                            ?>
                            <option value="<?php echo $crow['id'];?>"><?php echo $crow['cropname'];?></option>
                            <?php
                        }
                    }
                    ?>
                    
                </select>
              </div>
              <div class="form-group">
                <label>Crop Variety</label>
                <select class="form-control" id="cvid" name="cvid">
                    <option selected disabled>Select Crop Variety</option>
                    
                </select>
              </div>
              
              <div class="form-group">
                <label>Class</label>
                <select class="form-control" name="class">
                    <option disabled selected>Select Class</option>
                    <option>T/L</option>
                    <option>F/S</option>
                    <option>Breeder</option>
                </select>
              </div>
              <div class="form-group">
                <label>Select Season</label>
                <select class="form-control" name="season">
                    <option disabled selected>Select Season</option>
                    <option>K</option>
                    <option>B</option>
                    
                </select>
              </div>
              <div class="form-group">
                <label>Lot No</label>
                <input type="text" class="form-control" name="lotno" required>
              </div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
          
          
          
        </div>
        
        
        
        
        <div class="col-md-6">
          
          
          <div class="card card-warning">
            <div class="card-header">
              <h3 class="card-title">Bag Details</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="card-body">
              <div class="form-group">
                <label for="inputEstimatedBudget">Quantity (in kgs)</label>
                <input type="text" class="form-control" name="amount" id="kgs">
              </div>
              <div class="form-group">
                <label for="inputSpentBudget">No of Bags</label>
                <input type="text" class="form-control" name="bags" id="bagno">
              </div>
              <div class="form-group">
                <label for="inputSpentBudget">Bags Weight (in kgs)</label>
                <input type="text" class="form-control" name="bagswt" value="0.6" step="0.1" id="bagwt">
              </div>
              
              <div class="form-group">
                <label for="inputSpentBudget">Delivery Weight</label>
                <input type="text" readonly class="form-control" name="delwt" id="delwt">
              </div>
              <div class="form-group">
                <label for="inputSpentBudget">Net Weight</label>
                <input type="text" readonly class="form-control" name="netwt" id="netwt">
              </div>
              
              
              
            </div>
            <!-- /.card-body -->
          </div>
          
          <div class="card card-success">
            <div class="card-header">
              <h3 class="card-title">Delivery Details</h3>

              <div class="card-tools">
                <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                  <i class="fas fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="card-body">
              
              
              
              
              <div class="form-group">
                <label for="inputSpentBudget">Challan Weight</label>
                <input type="text" class="form-control" name="rate">
              </div>
              <div class="form-group">
                <label for="inputSpentBudget">Actual Weight</label>
                <input type="text" class="form-control" name="rate">
              </div>
              <div class="form-group">
                <label for="inputSpentBudget">Rate</label>
                <input type="text" class="form-control" name="rate">
              </div>
              
            </div>
            <!-- /.card-body -->
          </div>
          
          
          
          
        </div>
        
      </div>
      <div class="row">
        <div class="col-12 mb-4 mt-3">
          <center>
          <input type="submit" value="Create new Production" class="btn btn-success">
          </center>
        </div>
      </div>
      </form>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <footer class="main-footer">
    <?php include("footer.php");?>
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script>
    $(document).ready(function(){
        
        $("#end-box").hide();
        
        $("#enfor").change(function(){
            
            let enfor=$("#enfor").val();
            
            $("#enlabel").text("Select "+enfor);
            $("#end-box").show(300);
            
            var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
        document.getElementById("endata").innerHTML = this.responseText;
      }
    };
    xmlhttp.open("GET", "getfordata.php?type=" + enfor, true);
    xmlhttp.send();
        });
        
        $("#cropid").change(function(){
            let cid=$("#cropid").val();
            
            var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
        document.getElementById("cvid").innerHTML = this.responseText;
      }
    };
    xmlhttp.open("GET", "getvardata.php?cid=" + cid, true);
    xmlhttp.send();
        });
        
        
        $("#kgs").on('input',function(){
            
            let kgs=parseFloat($("#kgs").val());
            let bags=parseFloat($("#bagno").val());
            let bwt=parseFloat($("#bagwt").val());
            
            
            $("#delwt").val(kgs*bags);
            $("#netwt").val(kgs*(bags-(bags*bwt)));
            
        });
        
        $("#bagno").on('input',function(){
            
            let kgs=parseFloat($("#kgs").val());
            let bags=parseFloat($("#bagno").val());
            let bwt=parseFloat($("#bagwt").val());
            
            
            $("#delwt").val(kgs*bags);
            $("#netwt").val(kgs*(bags-(bags*bwt)));
            
            /*alert(parseInt(kgs)*parseInt(bags));*/
            
        });
        
        $("#bagwt").on('input',function(){
            
            let kgs=parseFloat($("#kgs").val());
            let bags=parseFloat($("#bagno").val());
            let bwt=parseFloat($("#bagwt").val());
            
            
            $("#delwt").val(kgs*bags);
            $("#netwt").val(kgs*(bags-(bags*bwt)));
            
            /*alert(parseInt(kgs)*parseInt(bags));*/
            
        });
        
        
        
        
    })
</script>

</body>
</html>
