/*
 * Decompiled with CFR 0.152.
 */
package com.geope.recharge;

import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.geope.recharge.Config;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import org.jetbrains.annotations.NotNull;

public class AdsManager {
    public int inter_i = 0;
    public InterstitialAd googleFullscreen;
    AdView admobSmallBanner;
    private static AdsManager mInstance;

    public static synchronized AdsManager getInstance() {
        if (mInstance == null) {
            mInstance = new AdsManager();
        }
        return mInstance;
    }

    public void showBannerAd(Activity activity, FrameLayout adContainerView) {
        if (Config.isAdsEnabled) {
            this.loadAdMOBBanner(activity, adContainerView);
        } else {
            adContainerView.setVisibility(8);
        }
    }

    public void loadAdMOBBanner(Activity activity, final FrameLayout adContainerView) {
        adContainerView.setVisibility(8);
        this.admobSmallBanner = new AdView((Context)activity);
        this.admobSmallBanner.setAdUnitId(Config.ADMOB_SMALL_BANNER_AD_ID);
        AdRequest adRequest = new AdRequest.Builder().build();
        AdSize adSize = this.getAdSize(activity);
        this.admobSmallBanner.setAdSize(adSize);
        this.admobSmallBanner.setAdListener(new AdListener(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                adContainerView.setVisibility(8);
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                adContainerView.removeAllViews();
                adContainerView.addView((View)AdsManager.this.admobSmallBanner);
                adContainerView.setVisibility(0);
            }
        });
        this.admobSmallBanner.loadAd(adRequest);
    }

    public AdSize getAdSize(Activity activity) {
        Display display = activity.getWindowManager().getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        float widthPixels = outMetrics.widthPixels;
        float density = outMetrics.density;
        int adWidth = (int)(widthPixels / density);
        return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)activity, (int)adWidth);
    }

    public void showInterAdOnClick(final Activity activity, final InterAdListener interAdListener, final String type) {
        if (Config.isAdsEnabled) {
            if (this.inter_i == Config.SHOW_INTER_ON_CLICKS) {
                this.inter_i = 0;
                if (this.googleFullscreen != null) {
                    this.googleFullscreen.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            interAdListener.onClick(type);
                            AdsManager.this.loadInterAd(activity);
                            super.onAdDismissedFullScreenContent();
                        }

                        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                            interAdListener.onClick(type);
                            AdsManager.this.loadInterAd(activity);
                            super.onAdFailedToShowFullScreenContent(adError);
                        }
                    });
                    this.googleFullscreen.show(activity);
                } else {
                    interAdListener.onClick(type);
                    this.loadInterAd(activity);
                }
            } else {
                ++this.inter_i;
                interAdListener.onClick(type);
            }
        } else {
            interAdListener.onClick(type);
        }
    }

    public void loadInterAd(Activity activity) {
        if (Config.isAdsEnabled) {
            final FullScreenContentCallback fullScreenContentCallback = new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    AdsManager.this.googleFullscreen = null;
                }

                public void onAdShowedFullScreenContent() {
                    super.onAdShowedFullScreenContent();
                }

                public void onAdFailedToShowFullScreenContent(@NotNull AdError adError) {
                    super.onAdFailedToShowFullScreenContent(adError);
                }
            };
            InterstitialAd.load((Context)activity, (String)Config.ADMOB_INTER_AD_ID, (AdRequest)new AdRequest.Builder().build(), (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdLoaded(@NonNull InterstitialAd ad) {
                    AdsManager.this.googleFullscreen = ad;
                    AdsManager.this.googleFullscreen.setFullScreenContentCallback(fullScreenContentCallback);
                }

                public void onAdFailedToLoad(@NonNull LoadAdError adError) {
                    AdsManager.this.googleFullscreen = null;
                    AdsManager.this.inter_i = 0;
                }
            });
        }
    }

    public void destroyBannerAds() {
        if (Config.isAdsEnabled && this.admobSmallBanner != null) {
            this.admobSmallBanner.removeAllViews();
            this.admobSmallBanner.destroy();
        }
    }

    public void destroyInterAds() {
        if (Config.isAdsEnabled && this.googleFullscreen != null) {
            this.googleFullscreen = null;
        }
    }

    public static interface InterAdListener {
        public void onClick(String var1);
    }
}

