/*
 * Decompiled with CFR 0.152.
 */
package com.geope.recharge.fragments;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import com.geope.recharge.AdsManager;
import com.geope.recharge.activity.MainActivity;

public class WebviewFragment
extends Fragment {
    public View view;
    @SuppressLint(value={"StaticFieldLeak"})
    public static WebView mwebView;
    private String URL;
    ProgressBar progressBar;
    private Button btnRetry;
    private RelativeLayout relativeLayout;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(2131427381, container, false);
        this.getActionBar().setTitle((CharSequence)this.getResources().getString(2131820581));
        this.relativeLayout = (RelativeLayout)view.findViewById(2131231128);
        this.btnRetry = (Button)view.findViewById(2131230831);
        this.URL = this.getArguments().getString("key_url");
        mwebView = (WebView)view.findViewById(2131231272);
        mwebView.setWebViewClient((WebViewClient)new MyBrowser());
        mwebView.setWebChromeClient((WebChromeClient)new myChrome());
        WebSettings webSettings = mwebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setDisplayZoomControls(false);
        webSettings.setSupportZoom(true);
        webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        webSettings.setDefaultTextEncodingName("utf-8");
        mwebView.getSettings().setPluginState(WebSettings.PluginState.ON);
        mwebView.getSettings().setLoadsImagesAutomatically(true);
        if (Build.VERSION.SDK_INT >= 34) {
            mwebView.getSettings().setMixedContentMode(0);
        }
        this.progressBar = (ProgressBar)view.findViewById(2131231123);
        this.progressBar.setVisibility(0);
        mwebView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4 && mwebView.canGoBack()) {
                    mwebView.goBack();
                    return true;
                }
                return false;
            }
        });
        this.btnRetry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                WebviewFragment.this.checkConnection();
            }
        });
        this.checkConnection();
        this.setHasOptionsMenu(true);
        return view;
    }

    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        if (this.getContext() != null) {
            menu2.clear();
            inflater.inflate(2131558400, menu2);
            MenuItem refreshWeb = menu2.findItem(2131231127);
            refreshWeb.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    WebviewFragment.this.checkConnection();
                    AdsManager.getInstance().showInterAdOnClick((Activity)WebviewFragment.this.getActivity(), new AdsManager.InterAdListener(){

                        @Override
                        public void onClick(String type) {
                            mwebView.reload();
                        }
                    }, "");
                    return false;
                }
            });
            super.onCreateOptionsMenu(menu2, inflater);
        }
    }

    private ActionBar getActionBar() {
        return ((MainActivity)this.getActivity()).getSupportActionBar();
    }

    public void checkConnection() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getActivity().getSystemService("connectivity");
        NetworkInfo wifi = connectivityManager.getNetworkInfo(1);
        NetworkInfo mobileNetwork = connectivityManager.getNetworkInfo(0);
        if (wifi.isConnected()) {
            mwebView.loadUrl(this.URL);
            mwebView.setVisibility(0);
            this.relativeLayout.setVisibility(8);
        } else if (mobileNetwork.isConnected()) {
            mwebView.loadUrl(this.URL);
            mwebView.setVisibility(0);
            this.relativeLayout.setVisibility(8);
        } else {
            mwebView.setVisibility(8);
            this.relativeLayout.setVisibility(0);
        }
    }

    public static WebviewFragment newInstance(String url) {
        WebviewFragment geturl = new WebviewFragment();
        Bundle args = new Bundle();
        args.putString("key_url", url);
        geturl.setArguments(args);
        return geturl;
    }

    private class MyBrowser
    extends WebViewClient {
        private MyBrowser() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            WebviewFragment.this.progressBar.setVisibility(0);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            WebviewFragment.this.progressBar.setVisibility(8);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            view.loadUrl("about:blank");
            WebviewFragment.this.checkConnection();
        }

        public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)WebviewFragment.this.getActivity());
            String message = "SSL Certificate error.";
            switch (error.getPrimaryError()) {
                case 3: {
                    message = "The certificate authority is not trusted.";
                    break;
                }
                case 1: {
                    message = "The certificate has expired.";
                    break;
                }
                case 2: {
                    message = "The certificate Hostname mismatch.";
                    break;
                }
                case 0: {
                    message = "The certificate is not yet valid.";
                }
            }
            message = message + " Do you want to continue anyway?";
            builder.setTitle((CharSequence)"SSL Certificate Error");
            builder.setMessage((CharSequence)message);
            builder.setPositiveButton((CharSequence)"continue", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    handler.proceed();
                }
            });
            builder.setNegativeButton((CharSequence)"cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    handler.cancel();
                }
            });
            AlertDialog dialog = builder.create();
            dialog.show();
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith("tel:") || url.startsWith("mailto:") || url.startsWith("whatsapp:") || url.startsWith("upi://pay") || url.startsWith("https://api.whatsapp.com") || url.startsWith("https://web.whatsapp.com")) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                WebviewFragment.this.startActivity(intent);
                return true;
            }
            WebviewFragment.this.progressBar.setVisibility(8);
            return false;
        }
    }

    private class myChrome
    extends WebChromeClient {
        private View mCustomView;
        private WebChromeClient.CustomViewCallback mCustomViewCallback;
        private int mOriginalSystemUiVisibility;

        myChrome() {
        }

        @SuppressLint(value={"SourceLockedOrientationActivity"})
        public void onHideCustomView() {
            ((FrameLayout)WebviewFragment.this.getActivity().getWindow().getDecorView()).removeView(this.mCustomView);
            this.mCustomView = null;
            WebviewFragment.this.getActivity().getWindow().getDecorView().setSystemUiVisibility(this.mOriginalSystemUiVisibility);
            WebviewFragment.this.getActivity().setRequestedOrientation(1);
            this.mCustomViewCallback.onCustomViewHidden();
            this.mCustomViewCallback = null;
        }

        @SuppressLint(value={"SourceLockedOrientationActivity"})
        public void onShowCustomView(View paramView, WebChromeClient.CustomViewCallback paramCustomViewCallback) {
            if (this.mCustomView != null) {
                this.onHideCustomView();
                return;
            }
            this.mCustomView = paramView;
            this.mOriginalSystemUiVisibility = WebviewFragment.this.getActivity().getWindow().getDecorView().getSystemUiVisibility();
            WebviewFragment.this.getActivity().setRequestedOrientation(0);
            paramView.setBackgroundColor(WebviewFragment.this.getResources().getColor(2131034145));
            this.mCustomViewCallback = paramCustomViewCallback;
            ((FrameLayout)WebviewFragment.this.getActivity().getWindow().getDecorView()).addView(this.mCustomView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            WebviewFragment.this.getActivity().getWindow().getDecorView().setSystemUiVisibility(3846);
        }
    }
}

